﻿var screenTranslationEditor = {
    context: $(".v-translateScreen"),
    questionnaireId: 0,
    errorOnSave: false,
    bindEvents: function () {
        screenTranslationEditor.context.on("click", ".v-switchScreen", function () {
            screenTranslationEditor.switchScreen($(this).attr("data-type"));
        });

        screenTranslationEditor.context.on("click", ".v-saveScreen", function () {
            $.when(screenTranslationEditor.saveScreen()).then(function () { modalDialog.close(); });
        });
        
        screenTranslationEditor.context.on("click", ".v-saveScreenAndNext", function () {
            $.when(screenTranslationEditor.saveScreen()).then(function () {                
                screenTranslationEditor.switchScreen("next");
            });
        });

        $(".v-translateLanguage, .v-referenceLanguage, .v-screenSelector", screenTranslationEditor.context).each(function () {
            $(this).data("prev", $(this).val());
        });

        screenTranslationEditor.context.on("change", ".v-translateLanguage, .v-referenceLanguage, .v-screenSelector", function () {
            var select = $(this);
            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (screenTranslationEditor.hasUnsavedChanges())
            {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(screenTranslationEditor.saveScreen())
                     .then(function () {
                         select.val(currentValue);
                         select.data("prev", currentValue);
                         screenTranslationEditor.updateScreenEditor();
                     });
                }, function () {
                    select.data("prev", currentValue);
                    screenTranslationEditor.updateScreenEditor();
                }, function () {
                    select.val(previousValue);
                });
            }
            else
            {
                select.data("prev", currentValue);
                screenTranslationEditor.updateScreenEditor();
            }
        });

        screenTranslationEditor.context.on("change", ".v-translationTextBox", function () {
            $(this).attr("data-changed", "true");
        });
    },
    switchScreen: function (type) {
        var $screensMenu = $(".v-screenSelector", screenTranslationEditor.context);
        var $selectedOption = $screensMenu.find(":selected");

        var $switchToOption = type == "next" ? $selectedOption.next($("option", $screensMenu)) : $selectedOption.prev($("option", $screensMenu));

        if ($switchToOption.length > 0)
        {
            $screensMenu.val($switchToOption.val());
            $screensMenu.trigger("change");
        }
    },
    updateScreenEditor: function () {
        var translationEdition = $(".v-translatorContainer", screenTranslationEditor.context);

        var args = {
            screenId: $(".v-screenSelector", screenTranslationEditor.context).val(),
            referenceLanguage: $(".v-referenceLanguage", screenTranslationEditor.context).val(),
            translationLanguage: $(".v-translateLanguage", screenTranslationEditor.context).val()
        }

        a4.callServerMethod(a4.getAction("GetTranslateScreenEditor", "Home", "Project", { questionnaireId: screenTranslationEditor.questionnaireId }), args, function (result) {
            translationEdition.empty().append(result);
        });
    },
    saveScreen: function () {
        var screen = { Id: $(".v-screenSelector", screenTranslationEditor.context).val() };
        var hasChange = false;
        var promise = null;

        $(".v-screenText[data-changed='true']", screenTranslationEditor.context).each(function () {
            screen[$(this).attr("data-key")] = $(this).val() || "";
            hasChange = true;
        });

        if (hasChange)
        {
            var args = {
                questionnaireId: screenTranslationEditor.questionnaireId,
                screen: screen,
                language: $(".v-translateLanguage", screenTranslationEditor.context).val()
            };

            promise = a4.callServerMethod(a4.getAction("UpdateScreen", "Home", "Project"), args, function (result) {
                a4.showSuccessMessage(resources.SuccessMessage, 2000);
                screenTranslationEditor.clearUnsavedChanges();
            });
        }

        return promise;
    },
    hasUnsavedChanges: function () {
        return $(".v-translationTextBox[data-changed='true']", screenTranslationEditor.context).length > 0;
    },
    clearUnsavedChanges: function () {
        return $(".v-translationTextBox[data-changed='true']", screenTranslationEditor.context).attr("data-changed", "false");
    }
}

$(document).ready(function () {
    if (screenTranslationEditor.context.length > 0){
        screenTranslationEditor.questionnaireId = $("#QuestionnaireId", screenTranslationEditor.context).val();
        screenTranslationEditor.bindEvents();
    }
});